Scriptname RF:SettingsScript Extends Quest

Actor PlayerRef

RF:FuelHandlerQuest Property RFQ Mandatory Const Auto
RF:TravelHandlerQuest Property RTQ Mandatory Const Auto
RF:DisasterScript Property RDQ Mandatory Const Auto ; damage quest

Group Settings

    Message Property DisableMSG Mandatory Const Auto
    { Displayed on transition to disabled }
    Message Property EnableMSG Mandatory Const Auto
    { Displayed on transition to enabled }

    GameplayOption Property _RF_GPO_MODE Mandatory Const Auto
    { This should be the main controller for all logic }
    GameplayOption Property _RF_GPO1 Mandatory Const Auto
    { Travel system where 1 is enabled }
    GameplayOption Property _RF_GPO_Acc Mandatory Const Auto
    { Determines if Cassiopeia logic will run }
    GameplayOption Property _RF_GPO2 Mandatory Const Auto
    { Verbosity where 1 is Verbose }
    GameplayOption Property _RF_GPO3 Mandatory Const Auto
    { Travel where 1 is Hardcore }
    GameplayOption Property _RF_GPO4 Mandatory Const Auto
    { Fuel explosion risk where 1 is hardcore - ship with normal system first }
    GameplayOption Property _RF_GPO5 Mandatory Const Auto
    { Cooldown system where 1 is enabled }
    GlobalVariable Property ModOnGlobal Const Auto
    { This can indicate mod state for other mods or scripts }
    GlobalVariable Property _RF_Sys_AllowTravel Mandatory Const Auto
    { Travel System where 1 is enabled }
    GlobalVariable Property _RF_Sys_Verbose Mandatory Const Auto
    { Verbosity where 1 is verbose }
    GlobalVariable Property _RF_EnableCassiopeiaLogic Mandatory Const Auto
    { RFO where 1 gets map data when possible}
    GlobalVariable Property _RF_Sys_TravelLimitHardcore Mandatory Const Auto
    { Travel Limiter where 1 is enabled }
    GlobalVariable Property _RF_Sys_FuelDamageHardcore Mandatory Const Auto
    { Fuel Detonation where 1 is enabled }
    GlobalVariable Property _RF_Sys_Cooldowns Mandatory Const Auto
    { Cooldown system where 1 is enabled}
EndGroup

Formlist Property _RF_SettingsList Mandatory Const Auto

bool ModActive = true

bool WaitingToReset = false ; Do we have a change queued from improper usage?

;Handler for global & all perks
;aiDisabled must correspond to whichever GPO return value disables the main system
Function CheckSettings(int aiDisabled = 1)
    ;Wait until menu is closed to avoid clogging VM
    Utility.Wait(0.5)
    ;GPO as int, where 0 is enabled (as default)
    int ModToggle = _RF_GPO_MODE.GetValue() as int
    ;Display a message when changing state
    If ModActive && ModToggle == aiDisabled
        DisableMSG.Show()
    ElseIf !ModActive && ModToggle != aiDisabled
        EnableMSG.Show()
    EndIf
    ;Set our bool for the main state to reference elsewhere
    if ModToggle == 0
        ModActive = true
        ModOnGlobal.SetValue(1)
    Else
        ModActive = false
        ModOnGlobal.SetValue(0)
    EndIf
    ;Global so other scripts can reference if needed
    If ModOnGlobal
        ModOnGlobal.SetValue(ModActive as int)
    EndIf
    int Mode1 = _RF_GPO1.GetValue() as int
    int Mode2 = _RF_GPO2.GetValue() as int
    int Mode3 = _RF_GPO3.GetValue() as int
    int Mode4 = _RF_GPO4.GetValue() as int
    int Mode5 = _RF_GPO5.GetValue() as int
    int ModeCass = _RF_GPO_Acc.GetValue() as int
    _RF_Sys_AllowTravel.SetValue(Mode1)
    _RF_Sys_Verbose.SetValue(Mode2)
    _RF_Sys_TravelLimitHardcore.SetValue(Mode3)
    _RF_Sys_FuelDamageHardcore.SetValue(Mode4)
    _RF_Sys_Cooldowns.SetValue(Mode5)
    _RF_EnableCassiopeiaLogic.SetValue(ModeCass)
    RFQ.HandleSettings()
    RTQ.HandleSettings()
    RDQ.HandleSettings()
    WaitingToReset = False
EndFunction

Event OnQuestInit()
	StartTimer(5)
    GoToState("Starting")
EndEvent

State Starting
    Event OnTimer(int aiTimerID)
    	RegisterForGameplayOptionChangedEvent()
        GotoState("")
    EndEvent
EndState

Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
    IF RealFuel.WasOptionChanged(aChangedOptions, _RF_SettingsList)
        Debug.Trace("RF Settings detected change with Waiting " + WaitingToReset)
        If !RFQ.StartupComplete()
            Debug.Trace("RF Settings running checks")
    	    CheckSettings()
        Else
            Debug.Notification("Settings unavailable! System not initialized.")
            WaitingToReset = True
        EndIf
    EndIF
    If WaitingToReset && !RFQ.StartupComplete()
        CheckSettings()
    EndIf
EndEvent

;1 indicates Disabled
int Function chkFUEL()
    Return _RF_GPO_MODE.GetValue() as int
EndFunction

;1 indicates No Restrictions
int Function chkTRV()
    Return _RF_GPO1.GetValue() as int
EndFunction

;
int Function chkHC()
    Return _RF_GPO3.GetValue() as int
EndFunction

int Function chkDSTR()
    Return 1 ; _RF_GPO4.GetValue() as int
EndFunction